/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.math.BigInteger;
import java.util.ArrayList;
import org.python.antlr.ErrorHandler;
import org.python.antlr.PythonParser;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.antlr.runtime.Token;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.codecs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarActions {
    private ErrorHandler errorHandler = null;

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    String makeFromText(java.util.List list, java.util.List<Name> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PythonTree.dottedNameListToString(list2));
        return stringBuilder.toString();
    }

    java.util.List<Name> makeModuleNameNode(java.util.List list, java.util.List<Name> list2) {
        ArrayList<Name> arrayList = new ArrayList<Name>();
        if (list != null) {
            for (Object e : list) {
                Token token = (Token)e;
                arrayList.add(new Name(token, token.getText(), expr_contextType.Load));
            }
        }
        if (null != list2) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    java.util.List<Name> makeDottedName(Token token, java.util.List<PythonTree> list) {
        ArrayList<Name> arrayList = new ArrayList<Name>();
        arrayList.add(new Name(token, token.getText(), expr_contextType.Load));
        if (list != null) {
            for (PythonTree pythonTree : list) {
                Token token2 = pythonTree.getToken();
                arrayList.add(new Name(token2, token2.getText(), expr_contextType.Load));
            }
        }
        return arrayList;
    }

    int makeLevel(java.util.List list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    java.util.List<alias> makeStarAlias(Token token) {
        ArrayList<alias> arrayList = new ArrayList<alias>();
        arrayList.add(new alias(token, "*", null));
        return arrayList;
    }

    java.util.List<alias> makeAliases(java.util.List<alias> list) {
        if (list == null) {
            return new ArrayList<alias>();
        }
        return list;
    }

    java.util.List<expr> makeBases(expr expr2) {
        ArrayList<expr> arrayList = new ArrayList<expr>();
        if (expr2 != null) {
            if (expr2 instanceof Tuple) {
                return ((Tuple)expr2).getInternalElts();
            }
            arrayList.add(expr2);
        }
        return arrayList;
    }

    java.util.List<String> makeNames(java.util.List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(((Token)list.get(i)).getText());
        }
        return arrayList;
    }

    Name makeNameNode(Token token) {
        if (token == null) {
            return null;
        }
        return new Name(token, token.getText(), expr_contextType.Load);
    }

    java.util.List<Name> makeNameNodes(java.util.List<Token> list) {
        ArrayList<Name> arrayList = new ArrayList<Name>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.makeNameNode(list.get(i)));
        }
        return arrayList;
    }

    void errorGenExpNotSoleArg(PythonTree pythonTree) {
        this.errorHandler.error("Generator expression must be parenthesized if not sole argument", pythonTree);
    }

    expr castExpr(Object object) {
        if (object instanceof expr) {
            return (expr)object;
        }
        if (object instanceof PythonTree) {
            return this.errorHandler.errorExpr((PythonTree)object);
        }
        return null;
    }

    java.util.List<expr> castExprs(java.util.List list) {
        return this.castExprs(list, 0);
    }

    java.util.List<expr> castExprs(java.util.List list, int n) {
        ArrayList<expr> arrayList = new ArrayList<expr>();
        if (list != null) {
            for (int i = n; i < list.size(); ++i) {
                Object e = list.get(i);
                if (e instanceof expr) {
                    arrayList.add((expr)e);
                    continue;
                }
                if (!(e instanceof PythonParser.test_return)) continue;
                arrayList.add((expr)((PythonParser.test_return)e).tree);
            }
        }
        return arrayList;
    }

    java.util.List<stmt> makeElse(java.util.List list, PythonTree pythonTree) {
        if (list != null) {
            return this.castStmts(list);
        }
        if (pythonTree == null) {
            return new ArrayList<stmt>();
        }
        ArrayList<stmt> arrayList = new ArrayList<stmt>();
        arrayList.add(this.castStmt(pythonTree));
        return arrayList;
    }

    stmt castStmt(Object object) {
        if (object instanceof stmt) {
            return (stmt)object;
        }
        if (object instanceof PythonParser.stmt_return) {
            return (stmt)((PythonParser.stmt_return)object).tree;
        }
        if (object instanceof PythonTree) {
            return this.errorHandler.errorStmt((PythonTree)object);
        }
        return null;
    }

    java.util.List<stmt> castStmts(PythonTree pythonTree) {
        stmt stmt2 = (stmt)pythonTree;
        ArrayList<stmt> arrayList = new ArrayList<stmt>();
        arrayList.add(stmt2);
        return arrayList;
    }

    java.util.List<stmt> castStmts(java.util.List list) {
        if (list != null) {
            ArrayList<stmt> arrayList = new ArrayList<stmt>();
            for (Object e : list) {
                arrayList.add(this.castStmt(e));
            }
            return arrayList;
        }
        return new ArrayList<stmt>();
    }

    expr makeDottedAttr(Token token, java.util.List list) {
        expr expr2 = new Name(token, token.getText(), expr_contextType.Load);
        for (Object e : list) {
            Token token2 = (Token)e;
            expr2 = new Attribute(token2, expr2, this.cantBeNoneName(token2), expr_contextType.Load);
        }
        return expr2;
    }

    stmt makeWhile(Token token, expr expr2, java.util.List list, java.util.List list2) {
        if (expr2 == null) {
            return this.errorHandler.errorStmt(new PythonTree(token));
        }
        java.util.List<stmt> list3 = this.castStmts(list2);
        java.util.List<stmt> list4 = this.castStmts(list);
        return new While(token, expr2, list4, list3);
    }

    stmt makeFor(Token token, expr expr2, expr expr3, java.util.List list, java.util.List list2) {
        if (expr2 == null || expr3 == null) {
            return this.errorHandler.errorStmt(new PythonTree(token));
        }
        this.cantBeNone(expr2);
        java.util.List<stmt> list3 = this.castStmts(list2);
        java.util.List<stmt> list4 = this.castStmts(list);
        return new For(token, expr2, expr3, list4, list3);
    }

    stmt makeTryExcept(Token token, java.util.List list, java.util.List<excepthandler> list2, java.util.List list3, java.util.List list4) {
        java.util.List<stmt> list5 = this.castStmts(list);
        java.util.List<excepthandler> list6 = list2;
        java.util.List<stmt> list7 = this.castStmts(list3);
        TryExcept tryExcept = new TryExcept(token, list5, list6, list7);
        if (list4 == null) {
            return tryExcept;
        }
        java.util.List<stmt> list8 = this.castStmts(list4);
        ArrayList<stmt> arrayList = new ArrayList<stmt>();
        arrayList.add(tryExcept);
        return new TryFinally(token, arrayList, list8);
    }

    TryFinally makeTryFinally(Token token, java.util.List list, java.util.List list2) {
        java.util.List<stmt> list3 = this.castStmts(list);
        java.util.List<stmt> list4 = this.castStmts(list2);
        return new TryFinally(token, list3, list4);
    }

    stmt makeFuncdef(Token token, Token token2, arguments arguments2, java.util.List list, java.util.List list2) {
        if (token2 == null) {
            return this.errorHandler.errorStmt(new PythonTree(token));
        }
        Name name = this.cantBeNoneName(token2);
        arguments arguments3 = arguments2 != null ? arguments2 : new arguments(token, new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
        java.util.List<stmt> list3 = this.castStmts(list);
        java.util.List<expr> list4 = this.castExprs(list2);
        return new FunctionDef(token, name, arguments3, list3, list4);
    }

    java.util.List<expr> makeAssignTargets(expr expr2, java.util.List list) {
        ArrayList<expr> arrayList = new ArrayList<expr>();
        this.checkAssign(expr2);
        arrayList.add(expr2);
        for (int i = 0; i < list.size() - 1; ++i) {
            expr expr3 = this.castExpr(list.get(i));
            this.checkAssign(expr3);
            arrayList.add(expr3);
        }
        return arrayList;
    }

    expr makeAssignValue(java.util.List list) {
        expr expr2 = this.castExpr(list.get(list.size() - 1));
        this.recurseSetContext(expr2, expr_contextType.Load);
        return expr2;
    }

    void recurseSetContext(PythonTree pythonTree, expr_contextType expr_contextType2) {
        if (pythonTree instanceof Context) {
            ((Context)((Object)pythonTree)).setContext(expr_contextType2);
        }
        if (pythonTree instanceof GeneratorExp) {
            GeneratorExp generatorExp = (GeneratorExp)pythonTree;
            this.recurseSetContext(generatorExp.getInternalElt(), expr_contextType2);
        } else if (pythonTree instanceof ListComp) {
            ListComp listComp = (ListComp)pythonTree;
            this.recurseSetContext(listComp.getInternalElt(), expr_contextType2);
        } else if (!(pythonTree instanceof ListComp)) {
            for (int i = 0; i < pythonTree.getChildCount(); ++i) {
                this.recurseSetContext(pythonTree.getChild(i), expr_contextType2);
            }
        }
    }

    arguments makeArgumentsType(Token token, java.util.List list, Token token2, Token token3, java.util.List list2) {
        java.util.List<expr> list3 = this.castExprs(list);
        java.util.List<expr> list4 = this.castExprs(list2);
        Name name = token2 == null ? null : this.cantBeNoneName(token2);
        Name name2 = token3 == null ? null : this.cantBeNoneName(token3);
        return new arguments(token, list3, name, name2, list4);
    }

    java.util.List<expr> extractArgs(java.util.List list) {
        return this.castExprs(list);
    }

    java.util.List<keyword> makeKeywords(java.util.List list) {
        ArrayList<keyword> arrayList = new ArrayList<keyword>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                java.util.List list2 = (java.util.List)list.get(i);
                this.checkAssign(this.castExpr(list2.get(0)));
                if (list2.get(0) instanceof Name) {
                    Name name = (Name)list2.get(0);
                    arrayList.add(new keyword(name, name.getInternalId(), this.castExpr(list2.get(1))));
                    continue;
                }
                this.errorHandler.error("keyword must be a name", (PythonTree)list2.get(0));
            }
        }
        return arrayList;
    }

    Object makeFloat(Token token) {
        return Py.newFloat(Double.valueOf(token.getText()));
    }

    Object makeComplex(Token token) {
        String string = token.getText();
        string = string.substring(0, string.length() - 1);
        return Py.newImaginary(Double.valueOf(string));
    }

    Object makeInt(Token token) {
        int n;
        String string = token.getText();
        int n2 = 10;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n2 = 16;
            string = string.substring(2, string.length());
        } else if (string.startsWith("0")) {
            n2 = 8;
        }
        if (string.endsWith("L") || string.endsWith("l")) {
            string = string.substring(0, string.length() - 1);
            return Py.newLong(new BigInteger(string, n2));
        }
        int n3 = string.length();
        for (n = 0; n < n3 && string.charAt(n) == '0'; ++n) {
        }
        if (n3 - n > 11) {
            return Py.newLong(new BigInteger(string, n2));
        }
        long l = Long.valueOf(string, n2);
        if (l > 0xFFFFFFFFL || l > Integer.MAX_VALUE) {
            return Py.newLong(new BigInteger(string, n2));
        }
        return Py.newInteger((int)l);
    }

    PyString extractStrings(java.util.List list, String string) {
        boolean bl = false;
        Token token2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (Token token2 : list) {
            StringPair stringPair = this.extractString(token2, string);
            if (stringPair.isUnicode()) {
                bl = true;
            }
            stringBuffer.append(stringPair.getString());
        }
        if (bl) {
            return new PyUnicode(stringBuffer.toString());
        }
        return new PyString(stringBuffer.toString());
    }

    StringPair extractString(Token token, String string) {
        String string2 = token.getText();
        char c = string2.charAt(0);
        int n = 0;
        boolean bl = false;
        if (c == 'u' || c == 'U') {
            bl = true;
            ++n;
        }
        c = string2.charAt(n);
        boolean bl2 = false;
        if (c == 'r' || c == 'R') {
            bl2 = true;
            ++n;
        }
        int n2 = 3;
        if (string2.length() - n == 2) {
            n2 = 1;
        }
        if (string2.charAt(n) != string2.charAt(n + 1)) {
            n2 = 1;
        }
        n = n2 + n;
        int n3 = string2.length() - n2;
        if (!bl && string != null) {
            string2 = new PyUnicode(string2.substring(n, n3)).encode(string);
            if (!bl2) {
                string2 = PyString.decode_UnicodeEscape(string2, 0, string2.length(), "strict", bl);
            }
        } else if (bl2) {
            string2 = string2.substring(n, n3);
            if (bl) {
                string2 = codecs.PyUnicode_DecodeRawUnicodeEscape(string2, "strict");
            }
        } else {
            string2 = PyString.decode_UnicodeEscape(string2, n, n3, "strict", bl);
        }
        return new StringPair(string2, bl);
    }

    Token extractStringToken(java.util.List list) {
        return (Token)list.get(0);
    }

    expr makeCall(Token token, expr expr2) {
        return this.makeCall(token, expr2, null, null, null, null);
    }

    expr makeCall(Token token, expr expr2, java.util.List list, java.util.List list2, expr expr3, expr expr4) {
        if (expr2 == null) {
            return this.errorHandler.errorExpr(new PythonTree(token));
        }
        java.util.List<keyword> list3 = this.makeKeywords(list2);
        java.util.List<expr> list4 = this.castExprs(list);
        return new Call(token, expr2, list4, list3, expr3, expr4);
    }

    expr negate(Token token, expr expr2) {
        return this.negate(new PythonTree(token), expr2);
    }

    expr negate(PythonTree pythonTree, expr expr2) {
        if (expr2 instanceof Num) {
            double d;
            Num num = (Num)expr2;
            if (num.getInternalN() instanceof PyInteger) {
                int n = ((PyInteger)num.getInternalN()).getValue();
                if (n >= 0) {
                    num.setN(new PyInteger(-n));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyLong) {
                BigInteger bigInteger = ((PyLong)num.getInternalN()).getValue();
                if (bigInteger.compareTo(BigInteger.ZERO) == 1) {
                    num.setN(new PyLong(bigInteger.negate()));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyFloat) {
                double d2 = ((PyFloat)num.getInternalN()).getValue();
                if (d2 >= 0.0) {
                    num.setN(new PyFloat(-d2));
                    return num;
                }
            } else if (num.getInternalN() instanceof PyComplex && (d = ((PyComplex)num.getInternalN()).imag) >= 0.0) {
                num.setN(new PyComplex(0.0, -d));
                return num;
            }
        }
        return new UnaryOp(pythonTree, unaryopType.USub, expr2);
    }

    String cantBeNone(Token token) {
        if (token == null || token.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(token));
        }
        return token.getText();
    }

    Name cantBeNoneName(Token token) {
        if (token == null || token.getText().equals("None")) {
            this.errorHandler.error("can't be None", new PythonTree(token));
        }
        return new Name(token, token.getText(), expr_contextType.Load);
    }

    void cantBeNone(PythonTree pythonTree) {
        if (pythonTree.getText().equals("None")) {
            this.errorHandler.error("can't be None", pythonTree);
        }
    }

    void checkAssign(expr expr2) {
        block4: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block7: {
                                                    block6: {
                                                        block5: {
                                                            block3: {
                                                                if (!(expr2 instanceof Name) || !((Name)expr2).getInternalId().equals("None")) break block3;
                                                                this.errorHandler.error("assignment to None", expr2);
                                                                break block4;
                                                            }
                                                            if (!(expr2 instanceof GeneratorExp)) break block5;
                                                            this.errorHandler.error("can't assign to generator expression", expr2);
                                                            break block4;
                                                        }
                                                        if (!(expr2 instanceof Num)) break block6;
                                                        this.errorHandler.error("can't assign to number", expr2);
                                                        break block4;
                                                    }
                                                    if (!(expr2 instanceof Str)) break block7;
                                                    this.errorHandler.error("can't assign to string", expr2);
                                                    break block4;
                                                }
                                                if (!(expr2 instanceof Yield)) break block8;
                                                this.errorHandler.error("can't assign to yield expression", expr2);
                                                break block4;
                                            }
                                            if (!(expr2 instanceof BinOp)) break block9;
                                            this.errorHandler.error("can't assign to operator", expr2);
                                            break block4;
                                        }
                                        if (!(expr2 instanceof BoolOp)) break block10;
                                        this.errorHandler.error("can't assign to operator", expr2);
                                        break block4;
                                    }
                                    if (!(expr2 instanceof Lambda)) break block11;
                                    this.errorHandler.error("can't assign to lambda", expr2);
                                    break block4;
                                }
                                if (!(expr2 instanceof Call)) break block12;
                                this.errorHandler.error("can't assign to function call", expr2);
                                break block4;
                            }
                            if (!(expr2 instanceof Repr)) break block13;
                            this.errorHandler.error("can't assign to repr", expr2);
                            break block4;
                        }
                        if (!(expr2 instanceof IfExp)) break block14;
                        this.errorHandler.error("can't assign to conditional expression", expr2);
                        break block4;
                    }
                    if (!(expr2 instanceof ListComp)) break block15;
                    this.errorHandler.error("can't assign to list comprehension", expr2);
                    break block4;
                }
                if (!(expr2 instanceof Tuple)) break block16;
                java.util.List<expr> list = ((Tuple)expr2).getInternalElts();
                if (list.size() == 0) {
                    this.errorHandler.error("can't assign to ()", expr2);
                }
                for (int i = 0; i < list.size(); ++i) {
                    this.checkAssign(list.get(i));
                }
                break block4;
            }
            if (!(expr2 instanceof List)) break block4;
            java.util.List<expr> list = ((List)expr2).getInternalElts();
            for (int i = 0; i < list.size(); ++i) {
                this.checkAssign(list.get(i));
            }
        }
    }

    java.util.List<expr> makeDeleteList(java.util.List list) {
        java.util.List<expr> list2 = this.castExprs(list);
        for (expr expr2 : list2) {
            this.checkDelete(expr2);
        }
        return list2;
    }

    void checkDelete(expr expr2) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if (!(expr2 instanceof Call)) break block3;
                            this.errorHandler.error("can't delete function call", expr2);
                            break block4;
                        }
                        if (!(expr2 instanceof Num)) break block5;
                        this.errorHandler.error("can't delete number", expr2);
                        break block4;
                    }
                    if (!(expr2 instanceof Str)) break block6;
                    this.errorHandler.error("can't delete string", expr2);
                    break block4;
                }
                if (!(expr2 instanceof Tuple)) break block7;
                java.util.List<expr> list = ((Tuple)expr2).getInternalElts();
                if (list.size() == 0) {
                    this.errorHandler.error("can't delete ()", expr2);
                }
                for (int i = 0; i < list.size(); ++i) {
                    this.checkDelete(list.get(i));
                }
                break block4;
            }
            if (!(expr2 instanceof List)) break block4;
            java.util.List<expr> list = ((List)expr2).getInternalElts();
            for (int i = 0; i < list.size(); ++i) {
                this.checkDelete(list.get(i));
            }
        }
    }

    slice makeSubscript(PythonTree pythonTree, Token token, PythonTree pythonTree2, PythonTree pythonTree3) {
        boolean bl = false;
        expr expr2 = null;
        expr expr3 = null;
        expr expr4 = null;
        if (pythonTree != null) {
            expr2 = this.castExpr(pythonTree);
        }
        if (token != null) {
            bl = true;
            if (pythonTree2 != null) {
                expr3 = this.castExpr(pythonTree2);
            }
        }
        if (pythonTree3 != null) {
            bl = true;
            expr4 = pythonTree3 != null ? this.castExpr(pythonTree3) : new Name(pythonTree3, "None", expr_contextType.Load);
        }
        PythonTree pythonTree4 = pythonTree;
        if (pythonTree == null) {
            pythonTree4 = new PythonTree(token);
        }
        if (bl) {
            return new Slice(pythonTree4, expr2, expr3, expr4);
        }
        return new Index(pythonTree4, expr2);
    }

    java.util.List<cmpopType> makeCmpOps(java.util.List list) {
        ArrayList<cmpopType> arrayList = new ArrayList<cmpopType>();
        if (list != null) {
            for (Object e : list) {
                arrayList.add((cmpopType)((Object)e));
            }
        }
        return arrayList;
    }

    BoolOp makeBoolOp(Token token, PythonTree pythonTree, boolopType boolopType2, java.util.List list) {
        ArrayList<PythonTree> arrayList = new ArrayList<PythonTree>();
        arrayList.add(pythonTree);
        arrayList.addAll(list);
        return new BoolOp(token, boolopType2, this.castExprs(arrayList));
    }

    BinOp makeBinOp(Token token, PythonTree pythonTree, operatorType operatorType2, java.util.List list) {
        BinOp binOp = new BinOp(token, this.castExpr(pythonTree), operatorType2, this.castExpr(list.get(0)));
        for (int i = 1; i < list.size(); ++i) {
            expr expr2 = this.castExpr(list.get(i));
            binOp = new BinOp(pythonTree, (expr)binOp, operatorType2, expr2);
        }
        return binOp;
    }

    BinOp makeBinOp(Token token, PythonTree pythonTree, java.util.List list, java.util.List list2, java.util.List list3) {
        BinOp binOp = new BinOp(token, this.castExpr(pythonTree), (operatorType)((Object)list.get(0)), this.castExpr(list2.get(0)));
        for (int i = 1; i < list2.size(); ++i) {
            expr expr2 = this.castExpr(list2.get(i));
            operatorType operatorType2 = (operatorType)((Object)list.get(i));
            binOp = new BinOp((Token)list3.get(i), (expr)binOp, operatorType2, expr2);
        }
        return binOp;
    }

    java.util.List<slice> castSlices(java.util.List list) {
        ArrayList<slice> arrayList = new ArrayList<slice>();
        if (list != null) {
            for (Object e : list) {
                arrayList.add(this.castSlice(e));
            }
        }
        return arrayList;
    }

    slice castSlice(Object object) {
        if (object instanceof slice) {
            return (slice)object;
        }
        return this.errorHandler.errorSlice((PythonTree)object);
    }

    slice makeSliceType(Token token, Token token2, Token token3, java.util.List list) {
        boolean bl = false;
        if (token2 != null || token3 != null) {
            bl = true;
        }
        slice slice2 = null;
        boolean bl2 = false;
        if (bl) {
            ArrayList<expr> arrayList = new ArrayList<expr>();
            for (Object e : list) {
                if (e instanceof Index) {
                    Index index = (Index)e;
                    arrayList.add(index.getInternalValue());
                    continue;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                Tuple tuple = new Tuple(token, arrayList, expr_contextType.Load);
                slice2 = new Index(token, (expr)tuple);
            }
        } else if (list.size() == 1) {
            slice2 = this.castSlice(list.get(0));
        } else if (list.size() != 0) {
            bl2 = true;
        }
        if (bl2) {
            java.util.List<slice> list2 = this.castSlices(list);
            slice2 = new ExtSlice(token, list2);
        }
        return slice2;
    }

    class StringPair {
        private String s;
        private boolean unicode;

        StringPair(String string, boolean bl) {
            this.s = string;
            this.unicode = bl;
        }

        String getString() {
            return this.s;
        }

        boolean isUnicode() {
            return this.unicode;
        }
    }
}

